#include "mex.h"
#include <math.h>
#include "..\C Routines\mxMatrix.h"

inline double sqr(double x) { return x*x; }

void mexFunction(int nhls, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
	char msg[120];

	if (nrhs!=3) {
		sprintf(msg,"RollFixedc_mq. Expecting 3 inputs; found %d.\n",nrhs);
		mexErrMsgTxt(msg);
	}

	MatrixRhs 
		mOld(prhs[0],"m"), 
		p(prhs[0],"p"), 
		ranu(prhs[1]);
	int T = mOld.length;
	if (p.n[0]!=1 || p.n[1]!=T) {
		sprintf(msg,"RollFixedc_mq. p is %d x %d. Expecting 1 x %d.\n", p.n[0], p.n[1], T);
		mexErrMsgTxt(msg);
	}
	if (ranu.length!=T) {
		sprintf(msg,"RollFixedc_mq. length of ranu=%d; expecting %d\n", ranu.length, T);
		mexErrMsgTxt(msg);
	}

	double 
		c	= GetDoubleFromStruct(prhs[2],"c"),
		varu= GetDoubleFromStruct(prhs[2],"varu");

	//	New matrices to hold constructed values;
	MatrixLhs m(1,T), q(1,T);

	int t;
	for (t=1; t<=T; t++) m(t) = mOld(t);
	for (t=1; t<=T; t++)
	{
		double mu, var;
		if (t==1) {
			mu = m(2);
			var = varu;
		}
		else if (t==T) {
			mu = m(t-1);
			var = varu;
		}
		else {
			mu = (m(t-1)+m(t+1))/2.;
			var = varu/2.;
		}

		double 
			PSell = exp(-sqr(p(t)+c-mu)/(2*var)),
			PBuy  = exp(-sqr(p(t)-c-mu)/(2*var));
		PBuy = PBuy/(PBuy+PSell);	//	Normalize
		q(t) = 1.;
		if (ranu(t)>PBuy) q(t)=-1.;
		m(t) = p(t) - q(t)*c;
	}

	//	Create return structure
	int dims[]={1,1};
	const char *fn[]={"m","q"};
	plhs[0]=mxCreateStructArray(2, dims, 2, fn);
	if (!plhs[0]) mexErrMsgTxt("RollFixedc_mq. Error in creating return structure.\n");
	mxSetField(plhs[0], 0, "m", m.mx);
	mxSetField(plhs[0], 0, "q", q.mx);
}